<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/TR/WD-xsl">
	<xsl:template match="/">
		<html>
			<head>
				<title>Factura Electrnica</title>
				<link rel="stylesheet" type="text/css" href="ebxml.css" />
			</head>
			<script language="JavaScript">
				function typeMoney(moneda) {
					var des = " - ";
					if(moneda == "PEN") {des = "SOLES";}
					if(moneda == "USD") {des = "DOLARES";}
					if(moneda == "XEU") {des = "EUROS";} 
					if(moneda == "EUR") {des = "EUROS";}
					if(moneda == "CAD") {des = "DOLAR CANADIENSE";}
					if(moneda == "GBP") {des = "LIBRA ESTERLINA";}
					if(moneda == "JPY") {des = "YEN";}
					if(moneda == "SEK") {des = "CORONA SUECA";}
					if(moneda == "CHF") {des = "FRANCO SUIZO";}
					document.write(des);
				}
				function simbolMoney(moneda) {
					var des = "";
					if(moneda == "PEN") {des = "S/";}
					if(moneda == "USD") {des = "&#36;";}
					if(moneda == "XEU") {des = "&#8364;";}
					if(moneda == "EUR") {des = "&#8364;";}
					if(moneda == "CAD") {des = "C&#36;";}
					if(moneda == "GBP") {des = "&#163;";}
					if(moneda == "JPY") {des = "&#165;";}
					if(moneda == "SEK") {des = "&#83;&#69;&#75;";}
					if(moneda == "CHF") {des = "&#83;&#119;&#70;";}
					document.write(des);
				}
				function descripTipoDoc(tipoDoc){					 
					var des = "";
					if(tipoDoc == "06" || tipoDoc == "6") {	des = "R.U.C.";	}
					if(tipoDoc == "04" || tipoDoc == "4") {	des = "C. EXT.";}
					if(tipoDoc == "07" || tipoDoc == "7") { des = "PASAPORTE";}
					if(tipoDoc == "01" || tipoDoc == "1") {	des = "D.N.I";}
					if(tipoDoc == "00" || tipoDoc == "0") {	des = "DT.S/RUC";}
					if(tipoDoc == "0A" || tipoDoc == "A") {	des = "CED.DIPL.";}				
					document.write(des);
				}
				
				function descripTipoCPRemitente(tipoDoc){					 
					var des = "";
					if(tipoDoc == "01" || tipoDoc == "1") {	des = "FACTURA GUIA";	}
					if(tipoDoc == "09" || tipoDoc == "9") {	des = "GUIA DE REMISION";}
					document.write(des);
				}
				
				function recuperarSerie(str){
					document.write(str.substring(0, str.indexOf("-")));
				}
				
				function recuperarNumero(str){
					document.write(str.substring(str.indexOf("-") + 1));
				}
				
				function descripMotivoTraslado(str){
					if (str == "1") document.write("Emisor Electrnico - Vendedor (Num. 3.1.1 Art. 21 RCP)");
					else if (str == "2") document.write("Comprador - Adquiriente o poseedor del bien (Num. 1.1 Art. 21 RCP)");
					else document.write("");
				}
				
				function descripModalidadTransporte(str){
					if (str == "1") document.write("Transporte Privado");
					else if (str == "2") document.write("Transporte Pblico");
					else document.write("");
				}
</script>
			<body>
				<TABLE ALIGN="center" class="form-table" width="700px">
					<tbody>
						<tr>
							<td width="30%">
								<TABLE>
									<TBODY>
										<tr class="bgn">
											<td>
												<xsl:value-of select="Invoice/cac:AccountingSupplierParty/cac:Party/cac:PartyName/cbc:Name" />
											</td>
										</tr>
										<tr class="bgn">
											<td>
												<xsl:value-of select="Invoice/cac:AccountingSupplierParty/cac:Party/cac:PartyLegalEntity/cbc:RegistrationName" />
											</td>
										</tr>
										<tr>
											<td>
												<xsl:value-of select="Invoice/cac:AccountingSupplierParty/cac:Party/cac:PostalAddress/cac:AddressLine/cbc:Line" />
												<xsl:value-of select="Invoice/cac:AccountingSupplierParty/cac:Party/cac:PostalAddress/cbc:BuildingNumber" />
											</td>
										</tr>
										<tr>
											<td>
												<xsl:value-of select="Invoice/cac:AccountingSupplierParty/cac:Party/cac:PostalAddress/cbc:CityName" />
												-
												<xsl:value-of select="Invoice/cac:AccountingSupplierParty/cac:Party/cac:PostalAddress/cbc:CountrySubentity" />
												-
												<xsl:value-of select="Invoice/cac:AccountingSupplierParty/cac:Party/cac:PostalAddress/cbc:District" />
											</td>
										</tr>
										<xsl:if test=".[Invoice/cac:SellerSupplierParty/cac:Party/cac:PostalAddress/cac:AddressLine/cbc:Line  != '']">
											<tr>
												<td>
													Establecimiento del Emisor:
													<xsl:value-of select="Invoice/cac:SellerSupplierParty/cac:Party/cac:PostalAddress/cac:AddressLine/cbc:Line" />
												</td>
											</tr>
										</xsl:if>
									</TBODY>
								</TABLE>
							</td>
							<td width="30%">
								<TABLE align="right" class="form-table-2">
									<TBODY>
										<tr>
											<td class="T2">FACTURA ELECTRONICA</td>
										</tr>
										<tr>
											<td class="T2">
												R.U.C.
												<xsl:value-of select="Invoice/cac:AccountingSupplierParty/cac:Party/cac:PartyIdentification/cbc:ID" />
											</td>
										</tr>
										<tr>
											<td class="T2">
												<xsl:value-of select="Invoice/cbc:ID" />
											</td>
										</tr>
									</TBODY>
								</TABLE>
							</td>
						</tr>

						<tr>
							<td colspan="2">
								<table width="100%" class="form-table-2">
									<tbody>
										<tr>
											<td width="48%">
												<TABLE>
													<TBODY>
														<TR class="bgn">
															<TD width="90">Fecha de Vencimiento:</TD>
															<TD>
																<xsl:value-of select="Invoice/cbc:DueDate" />
															</TD>
														</TR>													
														<TR class="bgn">
															<TD width="90">Fecha de emisin:</TD>
															<TD>
																<xsl:value-of select="Invoice/cbc:IssueDate" />
															</TD>
														</TR>
														<TR class="bgn">
															<TD>Seor(es):</TD>
															<TD>				
																<xsl:value-of select="Invoice/cac:AccountingCustomerParty/cac:Party/cac:PartyLegalEntity/cbc:RegistrationName" />
															</TD>
														</TR>
														<TR class="bgn">
															<TD>
																<script>
																	descripTipoDoc("<xsl:value-of select='Invoice/cac:AccountingCustomerParty/cac:Party/cac:PartyIdentification/cbc:ID/@schemeID' />");
																</script>
																:
															</TD>
															<TD>
																<xsl:value-of
																	select="Invoice/cac:AccountingCustomerParty/cac:Party/cac:PartyIdentification/cbc:ID" />
															</TD>
														</TR>
														<xsl:if test=".[Invoice/cac:AccountingCustomerParty/cac:Party/cac:PostalAddress/cac:AddressLine/cbc:Line  != '']">
															<TR class="bgn">
																<td>
																	Direccin del cliente:																	
																</td>
																<td>
																	<xsl:value-of select="Invoice/cac:AccountingCustomerParty/cac:Party/cac:PostalAddress/cac:AddressLine/cbc:Line" />
																</td>
															</TR>
														</xsl:if>
														<TR class="bgn">
															<td width="100">Tipo de Moneda:</td>
															<td>
																<script>
																	typeMoney("<xsl:value-of select='Invoice/cbc:DocumentCurrencyCode' />");
																</script>
															</td>
														</TR>
														<TR class="bgn">
															<td width="100">Observacin:</td>
															<td>
																<xsl:value-of select="Invoice/cbc:Note" />
															</td>
														</TR>
													</TBODY>
												</TABLE>
											</td>
											<td width="52%" valign="top" align="right">												
												<table width="100%">
													<xsl:for-each select="Invoice/cac:DespatchDocumentReference">
														<tr>
															<td width="70%">
																<xsl:value-of select="cbc:DocumentType" />
															</td>
															<td width="30%" align="right">
																<xsl:value-of select="cbc:ID" />
															</td>
														</tr>
													</xsl:for-each>														
													<xsl:for-each select="Invoice/cac:AdditionalDocumentReference">
														<tr>
															<td width="70%">
																<xsl:value-of select="cbc:DocumentType" />
															</td>
															<td width="30%" align="right">
																<xsl:value-of select="cbc:ID" />
															</td>
														</tr>
													</xsl:for-each>														
												</table>												
											</td>
										</tr>
									</tbody>
								</table>
							</td>
						</tr>
						<tr>
							<td colspan="2">
								<TABLE width="100%" class="form-table">
									<TBODY>
										<tr class="beta" align="center">
											<td width="20">	</td>
											<td width="10%">CANTIDAD</td>
											<td width="15%">UNIDAD MEDIDA</td>
											<td width="10%">CODIGO</td>
											<td width="49%">DESCRIPCION</td>
											<td width="18%">VALOR UNITARIO</td>
										</tr>
										<xsl:for-each select="Invoice/cac:InvoiceLine">
											<tr>
												<td align="center">
													<xsl:value-of select="cac:OrderLineReference/cbc:LineID" />
												</td>
												<td align="center">
													<xsl:value-of select="cbc:InvoicedQuantity" />
												</td>
												<td align="center">
													<xsl:value-of select="cbc:InvoicedQuantity/@unitCode" />
												</td>
												<td align="center">
													<xsl:value-of select="cac:Item/cac:SellersItemIdentification/cbc:ID" />
												</td>
												<td>
													<xsl:value-of select="cac:Item/cbc:Description" />
												</td>
												
												  <xsl:if test=".[cac:Price/cbc:PriceAmount &gt; 0]">
  												  <td align="right">
  													     <xsl:value-of select="cac:Price/cbc:PriceAmount" />
  													</td>
													</xsl:if>	
												  <xsl:if test=".[cac:Price/cbc:PriceAmount &lt; 0]">
  												  <td align="right">
  													</td>
													</xsl:if>													
											</tr>
										</xsl:for-each>
									</TBODY>
								</TABLE>
							</td>
						</tr>
						<tr>
							<td colspan="2">
								<table width="100%">
									<tr>
										<td width="60%">
											<table>
												<xsl:for-each select="Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/sac:AdditionalInformation/sac:AdditionalMonetaryTotal">
												   <xsl:choose>
												   <xsl:when match=".[cbc:ID = 1004]">
													 <tr>
														<td>VALOR DE VENTA DE OPERACIONES GRATUITAS</td>
														<td><script>	simbolMoney("<xsl:value-of select='Invoice/cbc:DocumentCurrencyCode' />");</script>
															<xsl:value-of select="cbc:PayableAmount" />
														</td>
													</tr>
												   </xsl:when>
												   </xsl:choose>
												</xsl:for-each>
										
												<xsl:for-each select="Invoice/">
												   <xsl:choose>
												   <xsl:when match=".[cbc:ID = 5000]">
												     <xsl:if test=".[cbc:Value != '  ' and cbc:Value != '']">
													   <tr>
														 <td width="50%"><xsl:value-of select="cbc:Name" /></td>
														 <td><xsl:value-of select="string(number(cbc:Value))" /></td>
													   </tr>
													 </xsl:if>
												   </xsl:when>
												   <xsl:when match=".[cbc:ID = 5001]">
													 <xsl:if test=".[cbc:Value != '  ' and cbc:Value != '']">
													   <tr>
														  <td><xsl:value-of select="cbc:Name" /></td>
														  <td><xsl:value-of select="cbc:Value" /></td>
													   </tr>
													 </xsl:if>
												   </xsl:when>	
												   <xsl:when match=".[cbc:ID = 5002]">
												     <xsl:if test=".[cbc:Value != '  ' and cbc:Value != '']">
													   <tr>
														 <td><xsl:value-of select="cbc:Name" /></td>
														 <td><xsl:value-of select="cbc:Value" /></td>
													   </tr>
													 </xsl:if>
												   </xsl:when>  
												  <xsl:when match=".[cbc:ID = 5003]">
												    <xsl:if test=".[cbc:Value != '  ' and cbc:Value != '']">
													  <tr>
														<td><xsl:value-of select="cbc:Name" /></td>
														<td><xsl:value-of select="cbc:Value" /></td>
													  </tr>
												    </xsl:if>
												  </xsl:when>
												  <xsl:when match=".[cbc:ID = 2007]">
												  </xsl:when>
												  <xsl:when match=".[cbc:ID = 2009]">
												  </xsl:when>
                           <xsl:otherwise>
                           <tr><td><xsl:value-of select="cbc:Note" /></td></tr>	
                            </xsl:otherwise>                                                  											   
												   </xsl:choose>												
												   											   
												</xsl:for-each>
                        <xsl:if test="Invoice/cac:OrderReference/cbc:ID">
							<xsl:if test=".[Invoice/cac:OrderReference/cbc:ID != '']">
												  <tr>
													<td>Orden de Compra</td>
													<td><xsl:value-of select="Invoice/cac:OrderReference/cbc:ID" /></td>
												  </tr>
							</xsl:if>
                        </xsl:if>												
                        <xsl:if test="Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/sac:AdditionalInformation/sac:SUNATCosts">
          							<xsl:if test=".[Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/sac:AdditionalInformation/sac:SUNATCosts/cac:RoadTransport/cbc:LicensePlateID != '']">
          												  <tr>
          													<td>Combustible y/o gastos mantenimiento-Placa Vehicular:</td>
          													<td><xsl:value-of select="Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/sac:AdditionalInformation/sac:SUNATCosts/cac:RoadTransport/cbc:LicensePlateID" /></td>
          												  </tr>
          							</xsl:if>
                        </xsl:if>											

											</table>
										</td>
										<td>
											<TABLE class="form-table" align="right">
												<TBODY>
												 <tr class="bgn" align="right">
													<td class="gamma">SUB TOTAL VENTAS</td>
													<td align="right">
														<script>
															simbolMoney("<xsl:value-of select='Invoice/cbc:DocumentCurrencyCode' />");
														</script>
														<xsl:value-of select="Invoice/cac:LegalMonetaryTotal/cbc:PrepaidAmount" />
  													</td>
												 </tr>		
												 <tr class="bgn" align="right">
														<td class="gamma">ANTICIPOS</td>
														<td align="right">
															<script>
																simbolMoney("<xsl:value-of select='Invoice/cbc:DocumentCurrencyCode' />");
															</script>
															<xsl:value-of select="Invoice/cac:LegalMonetaryTotal/cbc:PrepaidAmount" />
														</td>
													</tr>	                         											
												 <tr class="bgn" align="right">
														<td class="gamma">DESCUENTOS</td>
														<td align="right">
															<script>
																simbolMoney("<xsl:value-of select='Invoice/cbc:DocumentCurrencyCode' />");
															</script>
															<xsl:value-of select="Invoice/cac:LegalMonetaryTotal/cbc:AllowanceTotalAmount" />
														</td>
													</tr>												
													<tr class="bgn" align="right">
														<td class="gamma" width="18%">VALOR VENTA</td>
														<td align="right" width="18%">
															<script>
																simbolMoney("<xsl:value-of select='Invoice/cbc:DocumentCurrencyCode' />");
															</script>
															<xsl:value-of select="Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount" />
														</td>
													</tr>
													<tr class="bgn" align="right">
														<td class="gamma" width="18%">ISC</td>
														<td align="right" width="18%">
															<script>
																simbolMoney("<xsl:value-of select='Invoice/cbc:DocumentCurrencyCode' />");
															</script>
															<xsl:value-of select="Invoice/cac:TaxTotal[cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme/cbc:ID=2000]/cbc:TaxAmount" />
														</td>
													</tr>
													<tr class="bgn" align="right">
														<td class="gamma" width="18%">IGV</td>
														<td align="right" width="18%">
															<script>
																simbolMoney("<xsl:value-of select='Invoice/cbc:DocumentCurrencyCode' />");
															</script>
															<xsl:value-of select="Invoice/cac:TaxTotal[cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme/cbc:ID=1000]/cbc:TaxAmount" />
														</td>
													</tr>
													<tr class="bgn" align="right">
														<td class="gamma" width="18%">OTROS TRIBUTOS</td>
														<td align="right" width="18%">
															<script>
																simbolMoney("<xsl:value-of select='Invoice/cbc:DocumentCurrencyCode' />");
															</script>
															<xsl:value-of select="Invoice/cac:TaxTotal[cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme/cbc:ID=9999]/cbc:TaxAmount" />
														</td>
													</tr>													
													<tr class="bgn" align="right">
														<td class="gamma">OTROS CARGOS</td>
														<td align="right">
															<script>
																simbolMoney("<xsl:value-of select='Invoice/cbc:DocumentCurrencyCode' />");
															</script>
															<xsl:value-of select="Invoice/cac:LegalMonetaryTotal/cbc:ChargeTotalAmount" />
														</td>
													</tr>								
													<tr class="bgn" align="right">
														<td class="gamma">IMPORTE TOTAL</td>
														<td align="right">
															<script>
																simbolMoney("<xsl:value-of select='Invoice/cbc:DocumentCurrencyCode' />");
															</script>
															<xsl:value-of select="Invoice/cac:LegalMonetaryTotal/cbc:PayableAmount" />
														</td>
													</tr>
												</TBODY>
											</TABLE>
										</td>
									</tr>
								</table>
							</td>
						</tr>
						<tr>
              <td colspan="2" >
			<xsl:if test="Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/sac:AdditionalInformation/sac:SUNATEmbededDespatchAdvice">
				<xsl:if test=".[Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/sac:AdditionalInformation/sac:SUNATTransaction = '11']">
					<table width="100%">
						<tr><td><b>DATOS DEL REMITENTE</b></td></tr>
                		<tr><td width="29%">RUC</td><td width="1%">:</td>							
						    <td width="70%"><xsl:value-of select="/Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/sac:AdditionalInformation/sac:SUNATEmbededDespatchAdvice/sac:OrderReference/sac:DocumentReference/cac:IssuerParty/cac:PartyIdentification/cbc:ID" />-<xsl:value-of select="/Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/sac:AdditionalInformation/sac:SUNATEmbededDespatchAdvice/sac:OrderReference/sac:DocumentReference/cac:IssuerParty/cac:PartyName/cbc:Name" /></td>
						</tr>
                        <tr><td>Tipo del Documento</td><td>:</td>							
						    <td><script>descripTipoCPRemitente("<xsl:value-of select="/Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/sac:AdditionalInformation/sac:SUNATEmbededDespatchAdvice/sac:OrderReference/sac:OrderTypeCode"/>");</script></td>
						</tr>
                        <tr><td>Nmero de Serie del Documento</td><td>:</td>							
							<td><script>recuperarSerie("<xsl:value-of select="/Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/sac:AdditionalInformation/sac:SUNATEmbededDespatchAdvice/sac:OrderReference/cbc:ID" />")</script></td>
						</tr>
						<tr><td>Nmero del Documento</td><td>:</td>							
							<td><script>recuperarNumero("<xsl:value-of select="/Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/sac:AdditionalInformation/sac:SUNATEmbededDespatchAdvice/sac:OrderReference/cbc:ID" />")</script></td>
						</tr>
        			</table>
                </xsl:if>
				
                <xsl:if test="Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/sac:AdditionalInformation/sac:SUNATEmbededDespatchAdvice/cac:Shipment">
					<table width="100%">										
  						<tr><td colspan="3"><b>DATOS DEL TRASLADO</b></td></tr>
						<tr><td width="29%"></td><td width="1%"></td><td width="70%"></td></tr>
						<xsl:if test=".[Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/sac:AdditionalInformation/sac:SUNATTransaction = '10']">
							<xsl:if test=".[/Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/sac:AdditionalInformation/sac:SUNATEmbededDespatchAdvice/cac:Shipment/cac:ShipmentStage/cbc:TransportModeCode = '1']">
								<tr><td>Fecha de inicio del traslado</td><td>:</td>
									<td><xsl:value-of select="/Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/sac:AdditionalInformation/sac:SUNATEmbededDespatchAdvice/cac:Shipment/cac:ShipmentStage/cac:TransitPeriod/cbc:StartDate" /></td>
								</tr>
							</xsl:if>
						</xsl:if>
						<xsl:if test=".[Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/sac:AdditionalInformation/sac:SUNATTransaction = '11']">							
							<tr><td>Fecha de inicio del traslado</td><td>:</td>
								<td><xsl:value-of select="/Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/sac:AdditionalInformation/sac:SUNATEmbededDespatchAdvice/cac:Shipment/cac:ShipmentStage/cac:TransitPeriod/cbc:StartDate" /></td>
							</tr>
						</xsl:if>
						<xsl:if test="Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/sac:AdditionalInformation/sac:SUNATEmbededDespatchAdvice/cac:Shipment/cbc:HandlingCode">
							<tr><td>Sujeto que realizar el traslado</td><td>:</td>
								<td><script>descripMotivoTraslado("<xsl:value-of select="/Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/sac:AdditionalInformation/sac:SUNATEmbededDespatchAdvice/cac:Shipment/cbc:HandlingCode" />")</script></td>
							</tr>							
						</xsl:if>
						<xsl:if test="Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/sac:AdditionalInformation/sac:SUNATEmbededDespatchAdvice/cac:Shipment/cac:ShipmentStage/cbc:TransportModeCode">
							<tr><td>Modalidad de Transporte</td><td>:</td>
								<td><script>descripModalidadTransporte("<xsl:value-of select="/Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/sac:AdditionalInformation/sac:SUNATEmbededDespatchAdvice/cac:Shipment/cac:ShipmentStage/cbc:TransportModeCode" />")</script></td>
							</tr>
						</xsl:if>
						<xsl:if test=".[Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/sac:AdditionalInformation/sac:SUNATTransaction = '11']">
							<xsl:if test=".[/Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/sac:AdditionalInformation/sac:SUNATEmbededDespatchAdvice/cbc:MarkAttentionIndicator = 'true']">
								<tr><td>Es Subcontratado</td><td>:</td><td>SI</td></tr>
							</xsl:if>
							<xsl:if test=".[/Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/sac:AdditionalInformation/sac:SUNATEmbededDespatchAdvice/cbc:MarkAttentionIndicator = 'false']">
								<tr><td>Es Subcontratado</td><td>:</td><td>NO</td></tr>
							</xsl:if>
						</xsl:if>						
						<xsl:if test=".[Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/sac:AdditionalInformation/sac:SUNATTransaction = '10']">
							<xsl:if test=".[/Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/sac:AdditionalInformation/sac:SUNATEmbededDespatchAdvice/cac:Shipment/cac:ShipmentStage/cbc:TransportModeCode = '2']">
								<tr><td>Fecha de entrega de los bienes al Transportista</td><td>:</td>
									<td><xsl:value-of select="/Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/sac:AdditionalInformation/sac:SUNATEmbededDespatchAdvice/cac:Shipment/cac:ShipmentStage/cac:TransitPeriod/cbc:StartDate" /></td>
								</tr>
							</xsl:if>
						</xsl:if>                       
						<xsl:if test="Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/sac:AdditionalInformation/sac:SUNATEmbededDespatchAdvice/cac:Shipment/cac:ShipmentStage/cac:CarrierParty/cac:PartyIdentification/cbc:ID">
							<xsl:if test=".[Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/sac:AdditionalInformation/sac:SUNATEmbededDespatchAdvice/cac:Shipment/cac:ShipmentStage/cac:CarrierParty/cac:PartyIdentification/cbc:ID != '']">
								<tr><td>RUC y Razon social del transportista subcontratante</td><td>:</td>
									<td>
									<xsl:value-of select="/Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/sac:AdditionalInformation/sac:SUNATEmbededDespatchAdvice/cac:Shipment/cac:ShipmentStage/cac:CarrierParty/cac:PartyIdentification/cbc:ID" />
									-
									<xsl:value-of select="/Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/sac:AdditionalInformation/sac:SUNATEmbededDespatchAdvice/cac:Shipment/cac:ShipmentStage/cac:CarrierParty/cac:PartyName/cbc:Name" />
									</td>
								</tr>
							</xsl:if>
						</xsl:if>
						<xsl:if test=".[Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/sac:AdditionalInformation/sac:SUNATEmbededDespatchAdvice/cac:Shipment/cbc:GrossWeightMeasure != '']">
							<tr><td>Peso Bruto Total de la Factura</td><td>:</td>
								<td><xsl:value-of select="/Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/sac:AdditionalInformation/sac:SUNATEmbededDespatchAdvice/cac:Shipment/cbc:GrossWeightMeasure" /></td>
							</tr>
						</xsl:if>
        			</table>
				</xsl:if>
				
				<table width="100%">
					<tr><td colspan="3"><b>DATOS DEL DESTINATARIO</b></td></tr>
					<tr><td width="29%"></td><td width="1%"></td><td width="70%"></td></tr>
					<xsl:if test=".[/Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/sac:AdditionalInformation/sac:SUNATEmbededDespatchAdvice/cac:DeliveryCustomerParty/cac:Party/cac:PartyLegalEntity/cbc:RegistrationName != '']">
						<tr><td>Apellidos y Nombres, denominacin o Razn Social</td><td>:</td>
							<td><xsl:value-of select="/Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/sac:AdditionalInformation/sac:SUNATEmbededDespatchAdvice/cac:DeliveryCustomerParty/cac:Party/cac:PartyLegalEntity/cbc:RegistrationName" /></td>
						</tr>
					</xsl:if>
					<xsl:if test=".[/Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/sac:AdditionalInformation/sac:SUNATEmbededDespatchAdvice/cac:DeliveryCustomerParty/cac:Party/cac:PartyLegalEntity/cbc:RegistrationName != '']">
						<tr><td>Nmero de <script>descripTipoDoc("<xsl:value-of select="/Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/sac:AdditionalInformation/sac:SUNATEmbededDespatchAdvice/cac:DeliveryCustomerParty/cbc:CustomerAssignedAccountID/@schemeID" />")</script></td><td>:</td>
							<td><xsl:value-of select="/Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/sac:AdditionalInformation/sac:SUNATEmbededDespatchAdvice/cac:DeliveryCustomerParty/cbc:CustomerAssignedAccountID" /></td>
						</tr>
					</xsl:if>
				</table>
				
      			<table width="100%">
					<tr><td colspan="5"><b>DATOS DEL PUNTO DE PARTIDA Y PUNTO DE LLEGADA</b></td></tr>
					<tr><td width="29%"></td><td width="1%"></td><td width="10%"></td><td width="15%"></td><td width="45%"></td></tr>
					<tr><td colspan="5"><b>Punto de Partida: </b><xsl:value-of select="Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/sac:AdditionalInformation/sac:SUNATEmbededDespatchAdvice/cac:Shipment/cac:OriginAddress/cbc:StreetName" /></td>
					</tr>
					<tr><td colspan="5"><b>Punto de Llegada: </b><xsl:value-of select="Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/sac:AdditionalInformation/sac:SUNATEmbededDespatchAdvice/cac:Shipment/cac:DeliveryAddress/cbc:StreetName" /></td>
					</tr>					
                    <xsl:if test="Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/sac:AdditionalInformation/sac:SUNATEmbededDespatchAdvice/cac:Shipment/cac:TransportHandlingUnit">  													  
						<tr><td colspan="5"><b>Datos de Transporte:</b></td>
						</tr>
						<tr><td>Nro de placa</td><td>:</td>
						    <td  colspan="3"><xsl:value-of select="Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/sac:AdditionalInformation/sac:SUNATEmbededDespatchAdvice/cac:Shipment/cac:TransportHandlingUnit/cbc:ID" /> 
							<xsl:for-each select="Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/sac:AdditionalInformation/sac:SUNATEmbededDespatchAdvice/cac:Shipment/cac:TransportHandlingUnit/cac:TransportEquipment">
							/ <xsl:value-of select="cbc:ID" />
							</xsl:for-each>                							
							</td>
						</tr>    
						<tr><td>Conductores</td><td>:</td>
							<td><b>Tipo Documento</b></td>
							<td><b>Nmero de Documento</b></td>
							<td><b>Apellidos y Nombres, denominacin o Razn Social</b></td>
						</tr>
						
						<xsl:for-each select="Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/sac:AdditionalInformation/sac:SUNATEmbededDespatchAdvice/cac:Shipment/cac:ShipmentStage/cac:DriverPerson">
							<tr>
								<td></td><td></td>
								<td><script>descripTipoDoc("<xsl:value-of select='cbc:ID/@schemeID' />")</script></td>								
								<td><xsl:value-of select='cbc:ID' /></td>
								<td><xsl:value-of select="cbc:OtherName" /></td>
							</tr>
						</xsl:for-each>
            		</xsl:if>	
                    <tr><td colspan="5" align="center" ></td></tr>
              		<tr><td colspan="5" align="center" class="form-table" >Este documento sustenta el traslado de bienes.</td></tr>
              		<tr><td colspan="5" align="center" ></td></tr>
      			</table>
      							
      							
             </xsl:if>	
             </td>
            </tr>
						<tr><td colspan="2" align="center" ></td></tr>						
						<tr><td colspan="2" align="center" class="form-table" ><xsl:if test=".[Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/sac:AdditionalInformation/sac:SUNATTransaction = '13']"><xsl:value-of select="Invoice/ext:UBLExtensions/ext:UBLExtension/ext:ExtensionContent/sac:AdditionalInformation/sac:AdditionalProperty[cbc:ID=2009]/cbc:Value" /><br/></xsl:if>Es una representacin impresa de la Factura Electrnica generada en el sistema de SUNAT. Puede verificarla utilizando la Clave Sol</td></tr>
						<tr><td colspan="2" align="center" ></td></tr>
					</tbody>
				</TABLE>

			</body>
		</html>
	</xsl:template>
</xsl:stylesheet> 
 