<?php
	/*-------------------------
	Autor: Ludwig Torres
	Web: www.tosayro.com
	Mail: ludwingtorres@gmail.com
	---------------------------*/
	session_start();
	if (!isset($_SESSION['user_login_status']) AND $_SESSION['user_login_status'] != 1) {
        header("location: login.php");
		exit;
        }
	$active_facturas="active";
	$active_productos="";
	$active_clientes="";
	$active_usuarios="";	
	$title="Registrar Compra | ".$title;
	
	/* Connect To Database*/
	include("config/config.php");
	require_once ("config/db.php");//Contiene las variables de configuracion para conectar a la base de datos
	require_once ("config/conexion.php");//Contiene funcion que conecta a la base de datos
?>
<!DOCTYPE html>
<html lang="en">
  <head>
    <?php include("head.php");?>
  </head>
  <body>
	<?php include("navbar.php");?>  
    <div class="container">
	<div class="panel panel-info">
	<div class="panel-heading">
		<h4><i class='glyphicon glyphicon-edit'></i> Nuevo Comprobante</h4>
	</div>
	<div class="panel-body">
		<?php 
			//include("modal/buscar_productos.php");
			include("modal/registro_proveedores.php");
			//include("modal/registro_productos.php");
		?>
		<form class="form-horizontal" role="form" id="datos_factura">
			<div class="form-group row">
				<label for="tipocomprobante" class="col-md-1 control-label">Tipo</label>
				<div class="col-md-2">
					<select class="form-control input-sm" id="id_typeDocument" name="id_typeDocument">
					<?php
						$sql_tipocomprobante=mysqli_query($con,"select * from tb_typedocument order by id_typeDocument");
						while ($rw=mysqli_fetch_array($sql_tipocomprobante)){
							$id_typeDocument=$rw["id_typeDocument"];
							$name_typeDocument=$rw["name_typeDocument"];
							if ($id_typeDocument==$_SESSION['id_typeDocument']){
								$selected="selected";
							} else {
								$selected="";
								}?>
						<option value="<?php echo $id_typeDocument?>" <?php echo $selected;?>><?php echo $name_typeDocument?></option>
						<?php
							}
						?>
					</select>
				</div>
				<label for="serie_comprobante" class="col-md-1 control-label">Número </label>
				<div class="col-md-2">
					<input type="text" class="form-control input-sm" id="num_document" name="num_document" placeholder="Número del documento" required>
				</div>
				<label for="femision" class="col-md-1 control-label">Fecha</label>
				<div class="col-md-2">
					<input type="date" class="form-control input-sm" id="femision" name="femision" onchange="vencimiento()" required>
				</div>		
			</div>
				
				<div class="form-group row">
				  <label for="ruc_cliente" class="col-md-1 control-label">RUC</label>
					  <div class="col-md-2">
						  <input type="text" class="form-control input-sm" id="ruc_cliente" placeholder="Seleccione proveedor" required>
						  <input id="id_cliente" name="id_cliente" type='hidden'>	
					  </div>
				  <label for="nombre_cliente" class="col-md-2 control-label">Razón Social</label>
					  <div class="col-md-6">
						  <input type="text" class="form-control input-sm" id="nombre_cliente" placeholder="Razon Social" readonly>
					  </div>
				</div>
				 
				<div class="form-group row">
				  <label for="direccion_cliente" class="col-md-1 control-label">Dirección</label>
					  <div class="col-md-6">
						  <input type="text" class="form-control input-sm" id="direccion_cliente" placeholder="Direccion del cliente" readonly>
					  </div>
				  <label for="tel1" class="col-md-1 control-label">Teléfono</label>
					  <div class="col-md-2">
						  <input type="text" class="form-control input-sm" id="tel1" placeholder="Teléfono" readonly>
					  </div>
				</div>
				
				<div class="form-group row">
					<label for="monto_documento" class="col-md-1 control-label">Monto</label>
					<div class="col-md-2">
						<input type="text" class="form-control input-sm" id="monto" name="monto" placeholder="Monto del documento" required>
					</div>
					<label for="tipo_moneda" class="col-md-1 control-label">Moneda</label>
					<div class="col-md-2">
						<select class='form-control input-sm' id="moneda" name="moneda">
							<?php
								$sql_moneda=mysqli_query($con,"select * from tb_moneda where flagActive_typeMoneda='1' order by id_typeMoneda");
								while ($rw=mysqli_fetch_array($sql_moneda)){
									$id_moneda=$rw["id_typeMoneda"];
									$nombre_moneda=$rw["name_typeMoneda"];
									if ($id_moneda==$_SESSION['id_typeMoneda']){
										$selected="selected";
									} else {
										$selected="";
									}?>
								<option value="<?php echo $id_moneda?>" <?php echo $selected;?>><?php echo $nombre_moneda?></option>
							<?php
								}
							?>
						</select>
					</div>
					<label for="condicionpago" class="col-md-1 control-label">Pago</label>
					<div class="col-md-2">
						<select class='form-control input-sm' id="dias_condicionpago" name="dias_condicionpago" onchange="vencimiento()">
							<?php
								$sql_condicionpago=mysqli_query($con,"select * from tb_credits where flagActive_credit='1' order by id_credit");
								while ($rw=mysqli_fetch_array($sql_condicionpago)){
									$id_condicionpago=$rw["id_credit"];
									$nombre_condicionpago=$rw["name_credit"];
									$dias_condicionpago=$rw["value_credit"];
									if ($id_condicionpago==$_SESSION['id_credit']){
										$selected="selected";
									} else {
										$selected="";
									}?>
								<option value="<?php echo $dias_condicionpago?>" <?php echo $selected;?>><?php echo $nombre_condicionpago?></option>
							<?php
								}
							?>
						</select>
					</div>
					<label for="fvencimiento" class="col-md-1 control-label">Vencimiento</label>
					<div class="col-md-2">
						<input type="text" class="form-control input-sm" id="fvencimiento" name="fvencimiento" value="" readonly>
					</div>
				</div>
				
				
				<div class="col-md-12">
					<div class="pull-right">
					<!-- 
						<button type="button" class="btn btn-default" data-toggle="modal" data-target="#nuevoProducto">
							<span class="glyphicon glyphicon-plus"></span> Nuevo producto
						</button> -->
						<button type="button" class="btn btn-default" data-toggle="modal" data-target="#nuevoProveedor">
							<span class="glyphicon glyphicon-user"></span> Nuevo proveedor
						</button>
						<button type="submit" class="btn btn-default">
							<span class="glyphicon glyphicon-floppy-saved"></span> Registrar
						</button>
						<button type="submit" class="btn btn-default">
							<span class="glyphicon glyphicon-print"></span> Imprimir
						</button>
					</div>	
				</div>
			</form>	
			
		<div id="resultados" class='col-md-12' style="margin-top:10px"></div><!-- Carga los datos ajax -->			
		</div>
	</div>		
		  <div class="row-fluid">
			<div class="col-md-12">			
			</div>	
		 </div>
	</div>
	<hr>
	<?php
	include("footer.php");
	?>
	<script type="text/javascript" src="js/VentanaCentrada.js"></script>
	<script type="text/javascript" src="js/nueva_factura.js"></script>
	<link rel="stylesheet" href="//code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css">
    <script src="//code.jquery.com/ui/1.11.4/jquery-ui.js"></script>
	<script>
		$(function() {
			$("#ruc_cliente").autocomplete({
				source: "./ajax/autocomplete/proveedores.php",
				minLength: 2,
				select: function(event, ui) {
					event.preventDefault();
					$('#id_cliente').val(ui.item.id_proveedor);
					$('#ruc_cliente').val(ui.item.ruc_proveedor);
					$('#nombre_cliente').val(ui.item.nombre_proveedor);
					$('#direccion_cliente').val(ui.item.direccion_proveedor);
					$('#tel1').val(ui.item.telefono_proveedor);
					$('#mail').val(ui.item.email_proveedor);
				}
			});
		});
					
		$("#ruc_cliente" ).on( "keydown", function(event) {
		//if (event.keyCode== $.ui.keyCode.LEFT || event.keyCode== $.ui.keyCode.RIGHT || event.keyCode== $.ui.keyCode.UP || event.keyCode== $.ui.keyCode.DOWN || event.keyCode== $.ui.keyCode.TAB || event.keyCode== $.ui.keyCode.BACKSPACE )
			if (event.keyCode== $.ui.keyCode.BACKSPACE ){
				$("#id_cliente" ).val("");
				$("#nombre_cliente" ).val("");
				$("#direccion_cliente" ).val("");
				$("#tel1" ).val("");
				$("#mail" ).val("");
			}
			if (event.keyCode==$.ui.keyCode.DELETE){
				$("#nombre_cliente" ).val("");
				$("#direccion_cliente" ).val("");
				$("#id_cliente" ).val("");
				$("#tel1" ).val("");
				$("#mail" ).val("");
			}
		});
		function vencimiento(){
			const options = {
				year: "numeric",
				month:"2-digit",
				day:"2-digit"
			}
			var fcredito = new Date(document.getElementById("femision").value);
			fcredito.setMinutes(fcredito.getMinutes() + fcredito.getTimezoneOffset());			
			var dcredito = parseInt(document.getElementById("dias_condicionpago").value);
			fcredito.setDate(fcredito.getDate()+dcredito);
			$("#fvencimiento").val(fcredito.toLocaleDateString('es-PE', options));
			//document.getElementById("fvencimiento").value=fcredito.toLocaleDateString();
		};
		
	</script>

  </body>
</html>