<?php
	/*-------------------------
	Autor: Ludwig Torres Ramirez
	Web: www.tosayro.com
	Mail: ludwingtorres@gmail.com
	File: inversiones.php
	---------------------------*/
	session_start();
	if (!isset($_SESSION['user_login_status']) AND $_SESSION['user_login_status'] != 1) {
        header("location: login.php");
		exit;
        }

	/* Connect To Database*/
	require_once ("config/db.php");//Contiene las variables de configuracion para conectar a la base de datos
	require_once ("config/conexion.php");//Contiene funcion que conecta a la base de datos
	
	$active_facturas="";
	$active_inversiones="active";
	$active_socios="";
	$active_usuarios="";	
	$title="Inversiones | Control de Inversiones -SISCOIN";
?>
<!DOCTYPE html>
<html lang="en">
  <head>
    <?php include("head.php");?>
  </head>
  <body>
	<?php
	include("navbar.php");
	?>
	<div class="container">
		<div class="panel panel-info">
			<div class="panel-heading">
				<div class="btn-group pull-right">
					<button type='button' class="btn btn-info" data-toggle="modal" data-target="#nuevaInversion"><span class="glyphicon glyphicon-plus" ></span> Nueva Inversión</button>
				</div>
				<h4><i class='glyphicon glyphicon-search'></i> Inversiones</h4>
			</div>
			<div class="panel-body">		
			<?php
			include("modal/registro_inversion.php");
			//include("modal/editar_inversion.php");
			include("modal/asignar_socio.php");
			?>
			<form class="form-horizontal" role="form" id="datos_cotizacion">
						<div class="form-group row">
							<label for="q" class="col-md-2 control-label">Centro Costo</label>
							<div class="col-md-5">
								<input type="text" class="form-control" id="q" placeholder="Nombre del centro de costo" onkeyup='load(1);'>
							</div>
							<div class="col-md-3">
								<button type="button" class="btn btn-default" onclick='load(1);'>
									<span class="glyphicon glyphicon-search" ></span> Buscar</button>
								<span id="loader"></span>
							</div>	
						</div>				
			</form>
				<div id="resultados"></div><!-- Carga los datos ajax -->
				<div class='outer_div'></div><!-- Carga los datos ajax -->	
			</div>
		</div>
	</div>
	<hr>
	
	<?php
	include("footer.php");
	?>
	<script type="text/javascript" src="js/inversiones.js"></script>
	
  </body>
</html>
<script>
$( "#guardar_inversion" ).submit(function( event ) {
  $('#guardar_datos').attr("disabled", true);
  
 var parametros = $(this).serialize();
	 $.ajax({
			type: "POST",
			url: "ajax/nueva_inversion.php",
			data: parametros,
			 beforeSend: function(objeto){
				$("#resultados_ajax_productos").html("Mensaje: Cargando...");
			  },
			success: function(datos){
			$("#resultados_ajax_productos").html(datos);
			$('#guardar_datos').attr("disabled", false);
			load(1);
		  }
	});
  event.preventDefault();
})

$( "#editar_producto" ).submit(function( event ) {
  $('#actualizar_datos').attr("disabled", true);
  
 var parametros = $(this).serialize();
	 $.ajax({
			type: "POST",
			url: "ajax/editar_producto.php",
			data: parametros,
			 beforeSend: function(objeto){
				$("#resultados_ajax2").html("Mensaje: Cargando...");
			  },
			success: function(datos){
			$("#resultados_ajax2").html(datos);
			$('#actualizar_datos').attr("disabled", false);
			load(1);
		  }
	});
  event.preventDefault();
})

$( "#asignar_inversion" ).submit(function( event ) {
  $('#asignar_socio').attr("disabled", true);
  alert('aca estamos...');
 var parametros = $(this).serialize();
	 $.ajax({
			type: "POST",
			url: "ajax/asignar_inversion.php",
			data: parametros,
			 beforeSend: function(objeto){
				$("#resultados_ajax3").html("Mensaje: Cargando...");
			  },
			success: function(datos){
			$("#resultados_ajax3").html(datos);
			$('#asignar_socio').attr("disabled", false);
			load(1);
		  }
	});
  event.preventDefault();
})
//pasa variables a modal
$('#asignaSocio').on('show.bs.modal', function(e) {
    var Idcampanha = $(e.relatedTarget).data('id');
    $(e.currentTarget).find('input[name="Idcampanha"]').val(Idcampanha);
});

//www.genesisvargasj.com/blog/cargar-select-dependiente-a-partir-de-la-seleccion-de-otro-select-con-ajax-y-php
	function cargaCampanha(val){
		//alert(val);
		//$('#respuesta_ajax_cargaCampanha').html("<img src="ajax-loader.gif" /> Mensaje: Cargando...");    
		var str=1;
		var parametros="id_terreno="+val+"&equal="+str;
		$.ajax({
			type: "POST",
			url: "ajax/seleccion_campanha.php",
			data: parametros,
			success: function(resp){
				$('#campanha').attr("disabled", false);
				$('#campanha').html(resp);
				$('#respuesta_ajax_cargaCampanha').html("");	
			}
		});
	}
	
	function cargaSocio(val){
		//alert(val);
		//$('#respuesta_ajax_cargaCampanha').html("<img src="ajax-loader.gif" /> Mensaje: Cargando...");    
		var parametros="id_campanha_socio="+val;
		$.ajax({
			type: "POST",
			url: "ajax/seleccion_socio.php",
			data: parametros,
			success: function(resp){
				$('#campanha').attr("disabled", false);
				$('#campanha').html(resp);
				$('#respuesta_ajax_cargaSocio').html("");	
			}
		});
	}
	
		function obtener_datos(id){
		var id_inversion = $("#id_inversion"+id).val();
		var id_campanha = $("#id_campanha"+id).val();
		var id_terreno = $("#id_terreno"+id).val();
		var num_recibo = $("#recibo"+id).val();
		var fecha_inversion = $("#fecha_inversion"+id).val();
		var nombre_terreno = $("#nombre_terreno"+id).val();
		var nombre_campanha = $("#nombre_campanha"+id).val();
		var monto_inversion = $("#monto_inversion"+id).val();
		var monto_asignado = $("#monto_asignado"+id).val();
		var monto_sinasignar = $("#monto_sinasignar"+id).val();
		
		$("#mod_inversion").val(id_inversion);
		$("#mod_Idcampanha").val(id_campanha);
		$("#mod_recibo").val(num_recibo);
		$("#mod_fecha").val(fecha_inversion);
		$("#mod_terreno").val(nombre_terreno);
		$("#mod_campanha").val(nombre_campanha);
		$("#mod_monto").val(monto_inversion);
		$("#mod_asignado").val(monto_asignado);
		$("#mod_sinasignar").val(monto_sinasignar);
		//alert(num_recibo+" "+fecha_inversion+" "+id_campanha+" "+nombre_terreno);
		var parametros="id_campanha_socio="+id_campanha+"&id_terreno="+id_terreno;
		//alert(parametros);
		$.ajax({
			type: "POST",
			url: "ajax/seleccion_socio.php",
			data: parametros,
			success: function(resp){				
				$('#mod_socio').html(resp);					
			}
		});
	}
</script>