<?php
	/*-------------------------
	Autor: Ludwig Torres Ramirez
	Web: www.tosayro.com
	Mail: ludwingtorres@gmail.com
	File: editar_inversion.php
	---------------------------*/
	session_start();
	if (!isset($_SESSION['user_login_status']) AND $_SESSION['user_login_status'] != 1) {
        header("location: login.php");
		exit;
        }
	$active_facturas="";
	$active_inversiones="active";
	$active_socios="";
	$active_usuarios="";	
	$title="Inversiones | Control de Inversiones -SISCOIN";
	
	/* Connect To Database*/
	require_once ("config/db.php");//Contiene las variables de configuracion para conectar a la base de datos
	require_once ("config/conexion.php");//Contiene funcion que conecta a la base de datos
	
	include("funciones.php");
	//echo "<script type='text/javascript'> alert('serial invalido') </script>";
	if (isset($_GET['id_inversion'])){
		$id_inversion=intval($_GET['id_inversion']);
		$campos="*";
		$sql_inversion=mysqli_query($con,"select * from tb_inversiones where tb_inversiones.id_inversion=".$id_inversion."");
		$count=mysqli_num_rows($sql_inversion);
		if ($count==1)
		{
				$rw_inversion=mysqli_fetch_array($sql_inversion);
				$id_inversion=$rw_inversion['id_inversion'];
				$num_recibo=$rw_inversion['num_recibo'];
				$recibo="RC-".str_pad($num_recibo, 5, "0", STR_PAD_LEFT);				
				$fecha_inversion=date("d/m/Y", strtotime($rw_inversion['fecha_inversion']));
				$monto_inversion=$rw_inversion['monto_inversion'];
				$id_campanha=$rw_inversion['id_campanha'];
				$monto_asignado=$rw_inversion['monto_asignado'];
				$monto_sinasignar=$rw_inversion['monto_sinasignar'];				
				$id_centrocosto=$rw_inversion['id_centrocosto'];
				$id_beneficiario=$rw_inversion['id_beneficiario'];
				$glosa=$rw_inversion['glosa'];
				$_SESSION['id_inversion']=$id_inversion;
				$_SESSION['monto_sinasignar']=$monto_sinasignar;
				$_SESSION['monto_asignado']=$monto_asignado;
		}	
		else
		{
			header("location: inversiones.php");
			//header("location: inicio.php");
			exit;	
		}
	} 
	else 
	{
		header("location: inversiones.php");
		exit;
	}
?>
<!DOCTYPE html>
<html lang="en">
  <head>
    <?php include("head.php");?>
  </head>
  <body>
	<?php
	include("navbar.php");
	?>  
    <div class="container">
	<div class="panel panel-info">
		<div class="panel-heading">
			<h4><i class='glyphicon glyphicon-edit'></i> Detalle Inversion</h4>
		</div>
		<div class="panel-body">
		<?php 
			include("modal/asignar_socio.php");
		?>
			<form class="form-horizontal" role="form" id="datos_inversion">
				<div class="form-group row">
					<label for="num_recibo" class="col-md-2 control-label">Recibo</label>
						<div class="col-md-2">
							<input type="text" class="form-control input-sm" id="recibo<?php echo $id_inversion;?>" value="<?php echo $recibo;?>" readonly>
							<input type="hidden" name="id_inversion" id="id_inversion<?php echo $id_inversion;?>" value="<?php echo $id_inversion;?>">	
						</div>
					<label for="fecha" class="col-md-1 control-label">Fecha</label>
						<div class="col-md-2">
							<input type="text" class="form-control input-sm" id="fecha_inversion<?php echo $id_inversion;?>" value="<?php echo $fecha_inversion;?>" readonly>
						</div>
					<label for="beneficiario" class="col-md-1 control-label">Beneficiario</label>
						<div class="col-md-2">
							<?php
							$nom_beneficiario = get_row("tb_beneficiarios","nombre_beneficiario","id_beneficiario",$id_beneficiario);
							?>
							<input type="text" class="form-control input-sm" id="beneficiario" placeholder="Beneficiario" readonly value="<?php echo $nom_beneficiario;?>">
						</div>
				</div>
				
				<div class="form-group row">
						<label for="terreno" class="col-md-2 control-label">Terreno</label>
						<div class="col-md-2">
							<?php
							$nom_terreno = get_row_equal("tb_terrenos, tb_campanhas","nombre_terreno","tb_campanhas.id_terreno=tb_terrenos.id_terreno AND tb_campanhas.id_campanha=".$id_campanha);
							?>
							<input type="text" class="form-control input-sm" id="nombre_terreno<?php echo $id_inversion;?>" value="<?php echo $nom_terreno;?>" readonly>
						</div>				
						<label for="campanha" class="col-md-1 control-label">Campaña</label>
						<div class="col-md-2">
							<?php
							$nom_campanha = get_row("tb_campanhas","nombre_campanha","id_campanha",$id_campanha);
							?>
							<input type="text" class="form-control input-sm" id="nombre_campanha<?php echo $id_inversion;?>" value="<?php echo $nom_campanha;?>" readonly>
							<input type="hidden" class="form-control input-sm" id="id_campanha<?php echo $id_inversion;?>" value="<?php echo $id_campanha;?>" readonly>
						</div>
						<label for="centrocosto" class="col-md-1 control-label">CentroCosto</label>
						<div class="col-md-2">
							<?php
							$nom_centrocosto = get_row("tb_centrocostos","nombre_centrocosto","id_centrocosto",$id_centrocosto);
							?>
							<input type="text" class="form-control input-sm" id="nombre_centrocosto<?php echo $id_inversion;?>" value="<?php echo $nom_centrocosto;?>" readonly>
						</div>
				</div>
				<div class="form-group row">
					<label for="glosa" class="col-md-2 control-label">Detalle</label>
					<div class="col-md-8">
						<input type="text" class="form-control input-sm" id="glosa" value="<?php echo $glosa;?>" readonly>
					</div>
				</div>
				<div class="form-group row">
					
					<label for="monto_inversion" class="col-md-8 control-label">Monto</label>
					<div class="col-md-2">
						<input type="text" class="form-control input-sm text-center" id="monto_inversion<?php echo $id_inversion;?>" value="<?php echo number_format($monto_inversion,2);?>" readonly>
						
					</div>
				</div>
				
				<div class="col-md-10">
					<div class="pull-right">
						<button type="submit" class="btn btn-default">
						  <span class="glyphicon glyphicon-refresh"></span> Actualizar datos
						</button>						
						<button type="button" class="btn btn-default" onclick="asignarInversion('<?php echo $id_inversion;?>');" data-toggle="modal" data-target="#asignaSocio">						 
						<span class="glyphicon glyphicon-user"></span> Asignar Socio
						</button>
						<button type="button" class="btn btn-default" onclick="imprimir_factura('<?php echo $id_factura;?>')">
						  <span class="glyphicon glyphicon-print"></span> Imprimir Recibo
						</button>
					</div>	
				</div>
			</form>	
			<div class="clearfix"></div>
			<div class="editar_factura" class='col-md-12' style="margin-top:10px"></div><!-- Carga los datos ajax -->				
			<div id="resultados" class='col-md-10' style="margin-top:10px"></div><!-- Carga los datos ajax -->			
			
		</div>
	</div>		
		 
	</div>
	<hr>
	<?php
	include("footer.php");
	?>
	<script type="text/javascript" src="js/VentanaCentrada.js"></script>
	<script type="text/javascript" src="js/editar_inversion.js"></script>
	<link rel="stylesheet" href="//code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css">
    <script src="//code.jquery.com/ui/1.11.4/jquery-ui.js"></script>
	<script>
		
	</script>

  </body>
</html>