<?php
	
	/*-------------------------
	Autor: Ludwig Torres Ramirez
	Web: www.tosayro.com
	Mail: ludwingtorres@gmail.com
	File: buscar_inversiones.php
	---------------------------*/
	include('is_logged.php');//Archivo verifica que el usario que intenta acceder a la URL esta logueado
	/* Connect To Database*/
	require_once ("../config/db.php");//Contiene las variables de configuracion para conectar a la base de datos
	require_once ("../config/conexion.php");//Contiene funcion que conecta a la base de datos
	//Archivo de funciones PHP
	include("../funciones.php");
	$action = (isset($_REQUEST['action'])&& $_REQUEST['action'] !=NULL)?$_REQUEST['action']:'';
	if (isset($_GET['id'])){
		$id_inversion=intval($_GET['id']);
		$query=mysqli_query($con, "select * from tb_detalles_inversiones where id_inversion=".$id_inversion);
		$count=mysqli_num_rows($query);
		if ($count==0){
			$id_campanha=get_row_equal("tb_inversiones","id_campanha","id_inversion=".$id_inversion."");
			$monto_gastado=get_row_equal("tb_campanhas","monto_gastado","id_campanha=".$id_campanha."");
			$monto_proyectado=get_row_equal("tb_campanhas","monto_proyectado","id_campanha=".$id_campanha."");
			$monto_inversion=get_row_equal("tb_inversiones","monto_inversion","id_inversion=".$id_inversion."");
			$monto_gastado -= $monto_inversion;	
			$indice_gasto = ($monto_gastado/$monto_proyectado)*100;
			
			$query_update_inversiones=mysqli_query($con,"UPDATE tb_inversiones SET estado_inversiones=2 WHERE id_inversion=".$id_inversion);
			$query_update_campanha=mysqli_query($con,"UPDATE tb_campanhas SET monto_gastado=".$monto_gastado.", indice_gasto=".$indice_gasto." WHERE id_campanha=".$id_campanha."");
			
			if (($query_update_inversiones)&&($query_update_campanha)){	
			?>
				<div class="alert alert-success alert-dismissible" role="alert">
				  <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				  <strong>Aviso!</strong> Registro eliminado exitosamente.
				</div>
			<?php 
			}	else {
					?>
					<div class="alert alert-danger alert-dismissible" role="alert">
					  <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					  <strong>Error!</strong> Lo siento algo ha salido mal intenta nuevamente.
					</div>
					<?php
				}
		} else {
			?>
			<div class="alert alert-danger alert-dismissible" role="alert">
				<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				<strong>Error!</strong> No se pudo eliminar éste registro. Existen asignaciones vinculadas a éste registro. 
			</div>
			<?php
			}
			
	}
	if($action == 'ajax'){
		// escaping, additionally removing everything that could be (html/javascript-) code
        $q = mysqli_real_escape_string($con,(strip_tags($_REQUEST['q'], ENT_QUOTES)));
		//$aColumns = array('codigo_producto', 'nombre_producto');//Columnas de busqueda
		$sTable = "tb_inversiones, tb_centrocostos, tb_campanhas, tb_terrenos";
		$sWhere = "";
		$sWhere.= "WHERE tb_inversiones.id_centrocosto=tb_centrocostos.id_centrocosto and tb_inversiones.id_campanha=tb_campanhas.id_campanha and tb_campanhas.id_terreno=tb_terrenos.id_terreno and estado_inversiones=1";
		if ( $_GET['q'] != "" ){
			$sWhere.= " and (tb_centrocostos.nombre_centrocosto like '%$q%')";	
		} 
		$sWhere.=" order by num_recibo asc";
		include 'pagination.php'; //include pagination file
		//pagination variables
		$page = (isset($_REQUEST['page']) && !empty($_REQUEST['page']))?$_REQUEST['page']:1;
		$per_page = 10; //how much records you want to show
		$adjacents  = 4; //gap between pages after number of adjacents
		$offset = ($page - 1) * $per_page;
		//Count the total number of row in your table*/
		$count_query   = mysqli_query($con, "SELECT count(*) AS numrows FROM $sTable  $sWhere");
		$row= mysqli_fetch_array($count_query);
		$numrows = $row['numrows'];
		$total_pages = ceil($numrows/$per_page);
		$reload = './inversiones.php';
		//main query to fetch the data
		$sql="SELECT * FROM  $sTable $sWhere LIMIT $offset,$per_page";
		$query = mysqli_query($con, $sql);
		//loop through fetched data
		if ($numrows>0){
			//$simbolo_moneda=get_row('perfil','moneda', 'id_perfil', 1);
			?>
			<div class="table-responsive">
			  <table class="table">
				<tr  class="info">
					<th>Recibo</th>
					<th>Fecha</th>
					<th>Terreno</th>
					<th>Campaña</th>					
					<th>Centro Costo</th>
					<th class='text-right'>Monto</th>
					<th class='text-right'>Asignado</th>
					<th class='text-right'>Sin Asignar</th>
					<th class='text-center'>Acciones</th>
					
				</tr>
				<?php
					while ($row=mysqli_fetch_array($query)){
						$id_inversion=$row['id_inversion'];
						$id_campanha=$row['id_campanha'];
						$id_terreno=$row['id_terreno'];
						$recibo_inversion=$row['num_recibo'];
						$recibo="RC-".str_pad($recibo_inversion, 5, "0", STR_PAD_LEFT);
						$fecha_inversion=$row['fecha_inversion'];
						$nombre_campanha=$row['nombre_campanha'];
						$nombre_terreno=$row['nombre_terreno'];
						$nombre_centrocosto=$row['nombre_centrocosto'];
						$monto_inversion=$row['monto_inversion'];
						$monto_asignado=$row['monto_asignado'];
						$monto_sinasignar=$row['monto_sinasignar'];
				?>
					<input type="hidden" value="<?php echo $id_inversion;?>" id="id_inversion<?php echo $id_inversion;?>">
					<input type="hidden" value="<?php echo $id_campanha;?>" id="id_campanha<?php echo $id_inversion;?>">
					<input type="hidden" value="<?php echo $id_terreno;?>" id="id_terreno<?php echo $id_inversion;?>">
					<input type="hidden" value="<?php echo $recibo;?>" id="recibo<?php echo $id_inversion;?>">
					<input type="hidden" value="<?php echo $fecha_inversion;?>" id="fecha_inversion<?php echo $id_inversion;?>">
					<input type="hidden" value="<?php echo $nombre_campanha;?>" id="nombre_campanha<?php echo $id_inversion;?>">
					<input type="hidden" value="<?php echo $nombre_terreno;?>" id="nombre_terreno<?php echo $id_inversion;?>">
					<input type="hidden" value="<?php echo $nombre_centrocosto;?>" id="nombre_centrocosto<?php echo $id_inversion;?>">
					<input type="hidden" value="<?php echo number_format($monto_inversion,2,'.','');?>" id="monto_inversion<?php echo $id_inversion;?>">
					<input type="hidden" value="<?php echo number_format($monto_asignado,2,'.','');?>" id="monto_asignado<?php echo $id_inversion;?>">
					<input type="hidden" value="<?php echo number_format($monto_sinasignar,2,'.','');?>" id="monto_sinasignar<?php echo $id_inversion;?>">
					<tr>
						<td><?php echo $recibo; ?></td>
						<td><?php echo $fecha_inversion; ?></td>
						<td><?php echo $nombre_terreno;?></td>
						<td><?php echo $nombre_campanha;?></td>					
						<td><?php echo $nombre_centrocosto;?></td>
						<td><span class='pull-right'><?php echo number_format($monto_inversion,2);?></span></td>
						<td><span class='pull-right'><?php echo number_format($monto_asignado,2);?></span></td>
						<td><span class='pull-right'><?php echo number_format($monto_sinasignar,2);?></span></td>
						<td><span class="pull-right">
							<a href="editar_inversion.php?id_inversion=<?php echo $id_inversion;?>" class='btn btn-default' title='Editar detalles'><i class="glyphicon glyphicon-edit"></i></a>
							<a href="#" class='btn btn-default' title='Asignar socio' onclick="obtener_datos('<?php echo $id_inversion;?>');" data-toggle="modal" data-target="#asignaSocio" data-id="<?php echo $id_campanha;?>"><i class="glyphicon glyphicon-user"></i></a>
							<a href="#" class='btn btn-default' title='Imprimir' onclick="imprimir('<?php echo $id_inversion;?>');" data-toggle="modal" data-target="#editarInversion"><i class="glyphicon glyphicon-print"></i></a>
							<a href="#" class='btn btn-default' title='Eliminar' onclick="eliminar('<?php echo $id_inversion; ?>')"><i class="glyphicon glyphicon-trash"></i> </a></span>
						</td>						
					</tr>
					<?php
				}
				?>
				<tr>
					<td colspan=6><span class="pull-right">
					<?php
					 echo paginate($reload, $page, $total_pages, $adjacents);
					?></span></td>
				</tr>
			  </table>
			</div>
		<?php
		} else {
		?>	
			<div class="table-responsive">
			  <table class="table">
				<tr  class="info">
					<th class='text-center'>No existe registro para mostrar...</th>
				</tr>
			  </table>
			</div>
		<?php
		}
	}
		?>