<?php

	/*-------------------------
	Autor: Ludwig Torres Ramirez
	Web: www.tosayro.com
	Mail: ludwingtorres@gmail.com
	File: buscar_campanhas.php
	---------------------------*/
	include('is_logged.php');//Archivo verifica que el usario que intenta acceder a la URL esta logueado
	/* Connect To Database*/
	require_once ("../config/db.php");//Contiene las variables de configuracion para conectar a la base de datos
	require_once ("../config/conexion.php");//Contiene funcion que conecta a la base de datos
	
	include("../funciones.php");
	$action = (isset($_REQUEST['action'])&& $_REQUEST['action'] !=NULL)?$_REQUEST['action']:'';
	if (isset($_GET['id'])){
		$id_campanha=intval($_GET['id']);
		$query=mysqli_query($con, "select * from tb_campanhas where id_campanha=".$id_campanha." and monto_gastado>0");
		$count=mysqli_num_rows($query);
		if ($count==0){
			$delete="delete from tb_campanhas where id_campanha='".$id_campanha."'";
			if ($delete1=mysqli_query($con,$delete)){
				?>
				<div class="alert alert-success alert-dismissible" role="alert">
				  <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				  <strong>Aviso!</strong> Registro eliminado exitosamente
				</div>
				<?php 
			}else {
				?>
				<div class="alert alert-danger alert-dismissible" role="alert">
				  <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				  <strong>Error!</strong> No se puedo eliminar los datos
				</div>
				<?php
			}
		} else {
			?>
			<div class="alert alert-danger alert-dismissible" role="alert">
				<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				<strong>Error!</strong> No se pudo eliminar esta campaña. Existen registro de inversiones vinculadas.
			</div>
			<?php
			}
	}
	if($action == 'ajax'){
		// escaping, additionally removing everything that could be (html/javascript-) code
         $q = mysqli_real_escape_string($con,(strip_tags($_REQUEST['q'], ENT_QUOTES)));
		 $sTable = "tb_campanhas, tb_terrenos";
		 $sWhere = "";
		 $sWhere.= "WHERE tb_campanhas.id_terreno=tb_terrenos.id_terreno";
		if ( $_GET['q'] != "" ){
			$sWhere.= " and  (tb_terrenos.nombre_terreno like '%$q%')";	
		}
		
		$sWhere.=" order by tb_campanhas.id_terreno desc";
		include 'pagination.php'; //include pagination file
		
		//pagination variables
		$page = (isset($_REQUEST['page']) && !empty($_REQUEST['page']))?$_REQUEST['page']:1;
		$per_page = 10; //how much records you want to show
		$adjacents  = 4; //gap between pages after number of adjacents
		$offset = ($page - 1) * $per_page;
		
		//Count the total number of row in your table*/
		$count_query = mysqli_query($con, "SELECT count(*) AS numrows FROM $sTable  $sWhere");
		$row= mysqli_fetch_array($count_query);
		$numrows = $row['numrows'];
		$total_pages = ceil($numrows/$per_page);
		$reload = './inicio.php';
		
		//main query to fetch the data
		$sql="SELECT * FROM  $sTable $sWhere LIMIT $offset,$per_page";
		$query = mysqli_query($con, $sql);
		
		//loop through fetched data
		if ($numrows>0){
			echo mysqli_error($con);
			?>
			<div class="table-responsive">
			  <table class="table">
				<tr  class="info">
					<th>Terreno</th>
					<th>Nombre Campaña</th>
					<th class='text-center'>Proyeción</th>
					<th class='text-center'>Gasto</th>
					<th class='text-center'>Estado</th>
					<th class='text-center'>Indice Inversión</th>
					<th class='text-center'>Riesgo</th>
					<th class='text-center'>Acciones</th>
				</tr>
			<?php
			while ($row=mysqli_fetch_array($query)){
				$id_campanha=$row['id_campanha'];
				$nombre_terreno=$row['nombre_terreno'];
				$nombre_campanha=$row['nombre_campanha'];
				$ubicaX_terreno=$row['ubicaX'];
				$ubicaY_terreno=$row['ubicaY'];
				//$fecha=date("d/m/Y", strtotime($row['fecha_factura']));
				$monto_proyectado=$row['monto_proyectado'];
				$monto_gastado=$row['monto_gastado'];
				$estado_campanha=$row['estado_campanha'];
				$btn_off='';
				if ($estado_campanha==1){$text_estado="Activa";$label_class='label-success';}
					else{$text_estado="Liquidada";$label_class='label-default'; $btn_off='disabled';}
				$indice_gasto=$row['indice_gasto'];
				if ($indice_gasto<=60) {$text_indice="Normal"; $label_classI='label-success';}
					elseif (($indice_gasto>60)&&($indice_gasto<=90)) {$text_indice="Medio"; $label_classI='label-warning';}
						else {$text_indice="Alto"; $label_classI='label-danger';}
			?>
				<input type="hidden" value="<?php echo $id_campanha;?>" id="id_campanha<?php echo $id_campanha;?>">
				<tr>
					<td><a href="#" data-toggle="tooltip" data-placement="top" title="<i class='glyphicon glyphicon-phone'></i> <?php echo $ubicaX_terreno;?><br><i class='glyphicon glyphicon-envelope'></i>  <?php echo $ubicaY_terreno;?>" ><?php echo $nombre_terreno;?></a></td>
					<td><?php echo $nombre_campanha; ?></td>
					<td class="text-center"><?php echo number_format($monto_proyectado,2); ?></td>
					<td class="text-center"><?php echo number_format($monto_gastado,2); ?></td>
					<td class='text-center'><span class="label <?php echo $label_class;?>"><?php echo $text_estado; ?></span></td>
					<td class='text-center'><?php echo number_format ($indice_gasto,2); ?> %</td>
					<td class='text-center'><span class="label <?php echo $label_classI;?>"><?php echo $text_indice; ?></span></td>					
					<td class="text-right">
						<a href="editar_factura.php?id_factura=<?php echo $id_factura;?>" class='btn btn-default <?php echo $btn_off; ?>' title='Liquidar' ><i class="glyphicon glyphicon-off"></i></a> 
						<a href="#" class='btn btn-default' title='Reporte' onclick="imprimir_campanha('<?php echo $id_campanha;?>');"><i class="glyphicon glyphicon-print"></i></a> 
						<a href="#" class='btn btn-default <?php echo $btn_off; ?>' title='Eliminar' onclick="eliminar('<?php echo $id_campanha;?>');"><i class="glyphicon glyphicon-trash"></i></a> 
					</td>
						
				</tr>
				<?php
			}
				?>
				<tr>
					<td colspan=8><span class="pull-right"><?php
					 echo paginate($reload, $page, $total_pages, $adjacents);
					?></span></td>
				</tr>
			  </table>
			</div>
			<?php
		}
	}
?>